package de.mse.uebung7;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;

public class PerformanceTests {

   static final int kRunCount = 2;
   static final int kMaxElementCount = 10 * 1000 * 1000;
   static final int kLookUpCount = 10 * 1000 * 1000;

   public static void main(String[] a) {
      Random random = new Random();

      // HashMap
      for (int tableSize = 10; tableSize < kMaxElementCount; tableSize *= 10) {
         HashMap<Integer, Integer> map = new HashMap<Integer, Integer>(tableSize);
         float ms = evaluatePerformance(map, random, tableSize) / 1000 / 1000.0f;
         System.out.println("HashMap\t" + tableSize + "\t" + ms);
      }

      // TreeMap
      for (int tableSize = 10; tableSize < kMaxElementCount; tableSize *= 10) {
         TreeMap<Integer, Integer> map = new TreeMap<Integer, Integer>();
         float ms = evaluatePerformance(map, random, tableSize) / 1000 / 1000.0f;
         System.out.println("TreeMap\t" + tableSize + "\t" + ms);
      }
   }

   private static long evaluatePerformance(Map<Integer, Integer> map, Random random, int tableSize) {
      ArrayList<Integer> values = new ArrayList<Integer>();

      // Initialize map
      for (int i = 0; i < tableSize; i++) {
         int key = random.nextInt();
         values.add(key);
         map.put(key, random.nextInt());
      }

      // Measure performance
      long begin = System.nanoTime();
      for (int run = 0; run < kRunCount; run++) {
         for (int i = 0; i < kLookUpCount; i++) {
            map.get(values.get(i % tableSize));
         }
      }

      return (System.nanoTime() - begin) / kRunCount;
   }
}
